<?php

namespace App\Http\Controllers;

use App\Models\Server;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class ServerController extends Controller
{
    private function querySteamApi($appId, $serverIp, $serverPort)
    {
        $apiKey = '7ADA74DA7745E41E5BC2C678199C98E0';
        
        $response = Http::get('https://api.steampowered.com/IGameServersService/GetServerList/v1/', [
            'filter' => "appid\\$appId\\addr\\$serverIp:$serverPort",
            'key' => $apiKey,
        ]);

        $data = $response->json();

        return isset($data['response']['servers'][0]) ? $data['response']['servers'][0] : null;
    }

    public function index()
    {
        $servers = Server::all();
        $serverData = [];
        foreach ($servers as $server) {
            $steamData = $this->querySteamApi(4000, $server->ip, $server->port);
            if ($steamData) {
                $serverData[] = $steamData;
            }
        }

        return response()->json([
            'status' => 'success',
            'servers' => $serverData,
        ]);
    }

    public function show(Server $server)
    {
        $steamData = $this->querySteamApi(4000, $server->ip, $server->port);
        
        if ($steamData) {
            return response()->json([
                'status' => 'success',
                'server_data' => $steamData
            ]);
        } else {
            return response()->json([
                'status' => 'error',
                'message' => 'No server found.'
            ], 404);
        }
    }
}
